/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.battery.CalculatedPowerStatus;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.JoinRequest;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.LabelRegistration;
import at.mrdevelopment.esl.core.LabelTagsLookup;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.core.WakeupListener;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.licensing.LicenseReloadListener;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.record.RegisteredLabel;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.server.LabelRegisterListener;
import at.mrdevelopment.esl.server.PersistLabelInfoCache;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.esl.type.UpdateInfo;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LabelInfoDataset
extends AbstractDataset<LabelInfo>
implements WakeupListener,
LabelTagsLookup,
LicenseReloadListener {
    static ESLLogger logger = ESLLogger.getLogger(LabelInfoDataset.class);
    public static final Version LABEL_FIRMWARE_EXTENDED_PROTOCOL_VERSION = Version.fromString((String)"2.3.1");
    private final ORMDataset<RegisteredLabel> registeredLabelDataset;
    private final FeatureUnlock featureUnlock;
    private PersistLabelInfoCache persistLabelInfoCache;
    private final TransactionSupplier transactionSupplier;
    private final SortedMap<LabelId, LabelInfo> registeredLabelInfos = new TreeMap<LabelId, LabelInfo>();
    private final SortedMap<LabelId, RegisteredLabel> registeredLabels = new TreeMap<LabelId, RegisteredLabel>();
    private final Set<LabelRegisterListener> labelRegisterListeners = new HashSet<LabelRegisterListener>();
    private boolean showConnectionStatusAsUnknown = false;

    public LabelInfoDataset(Map<Role, DatasetPermissions> datasetPermissions, FeatureUnlock featureUnlock, PersistLabelInfoCache persistLabelInfoCache, TransactionSupplier transactionSupplier) throws DatasetException, InitializationException {
        super(LabelInfo.class, datasetPermissions);
        this.registeredLabelDataset = new DefaultORMDataset<RegisteredLabel>(RegisteredLabel.class, datasetPermissions);
        this.featureUnlock = featureUnlock;
        this.persistLabelInfoCache = persistLabelInfoCache;
        this.transactionSupplier = transactionSupplier;
    }

    public ORMDataset<RegisteredLabel> getRegisteredLabelDataset() {
        return this.registeredLabelDataset;
    }

    public void init(Transaction<?> transaction) throws DatasetException, SerializeException {
        this.reloadRegisteredLabels(transaction);
    }

    public LabelInfo queryById(long id, Transaction<?> transaction) throws DatasetException {
        return this.manipulateLabelErrors((LabelInfo)this.registeredLabelInfos.get(new LabelId(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LabelInfo> queryAll(Transaction<?> transaction) {
        int offlineTimeoutInMinutes = Config.getPingLabelsIntervalInMinutes() + Config.getLabelOnlineTimeoutOffsetInMinutes();
        DateTime offlineTime = DateTime.now().minusMinutes(offlineTimeoutInMinutes);
        int unknownTimeoutInMinutes = Config.getBatteryStatusClassificationDataDurabilityMinutes() + Config.getBatteryStatusClassificationUnknownTimeoutOffsetInMinutes();
        DateTime unknownPowerStatusTime = DateTime.now().minusMinutes(unknownTimeoutInMinutes);
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            ArrayList<LabelInfo> labels = new ArrayList<LabelInfo>(this.registeredLabelInfos.size());
            for (LabelInfo labelInfo : this.registeredLabelInfos.values()) {
                boolean legacyFirmware;
                boolean available = labelInfo.getWakeupTime() != null && labelInfo.getWakeupTime().isAfter((ReadableInstant)offlineTime);
                boolean bl = legacyFirmware = labelInfo.getFirmwareVersion() != null && labelInfo.getFirmwareVersion().isOlder(LABEL_FIRMWARE_EXTENDED_PROTOCOL_VERSION);
                if (Config.isBatteryStatusClassificationEnabled()) {
                    PowerStatus powerStatus = labelInfo.getCalculatedPowerStatus().getTimestamp() == null || labelInfo.getCalculatedPowerStatus().getTimestamp().isBefore((ReadableInstant)unknownPowerStatusTime) ? PowerStatus.UNKNOWN : labelInfo.getCalculatedPowerStatus().getPowerStatus();
                    labelInfo.setPowerStatus(powerStatus);
                }
                if (!available && legacyFirmware && this.showConnectionStatusAsUnknown) {
                    labelInfo.setConnectionStatus(ConnectionStatus.UNKNOWN);
                } else if (available) {
                    labelInfo.setConnectionStatus(ConnectionStatus.ONLINE);
                } else {
                    labelInfo.setConnectionStatus(ConnectionStatus.OFFLINE);
                    labelInfo.setSyncQuality(null);
                    labelInfo.setRssi(null);
                    labelInfo.setLqi(null);
                    labelInfo.setCurrentPage(null);
                    if (!Config.isBatteryStatusClassificationEnabled()) {
                        labelInfo.setPowerStatus(null);
                    }
                }
                this.manipulateLabelErrors(labelInfo);
                labels.add(labelInfo);
            }
            return labels;
        }
    }

    private LabelInfo manipulateLabelErrors(LabelInfo labelInfo) {
        if (labelInfo == null) {
            return null;
        }
        if (Config.isIgnoreExperimentalLabelErrors()) {
            labelInfo.setLabelErrors(LabelErrors.createWithoutExperimentalLabelErrors((LabelErrors)labelInfo.getLabelErrors()));
        }
        return labelInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LabelRegistration> getRegisteredLabels() {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            return Lists.newArrayList((Iterable)Iterables.transform(this.registeredLabels.values(), (Function)new Function<RegisteredLabel, LabelRegistration>(){

                public LabelRegistration apply(RegisteredLabel registeredLabel) {
                    return registeredLabel.toLabelRegistration();
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LabelId, RegisteredLabel> getLabelRegistration() {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            return new HashMap<LabelId, RegisteredLabel>(this.registeredLabels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount(Transaction<?> transaction) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            return this.registeredLabelInfos.size();
        }
    }

    public void store(Collection<LabelInfo> records, UserId user, Transaction<?> transaction) throws DatasetException {
        for (LabelInfo labelInfo : records) {
            if (this.registerLabel(labelInfo.getLabelId(), labelInfo.getPin(), labelInfo.getTags(), user, transaction)) {
                labelInfo.setCommitState(CommitState.INSERTED);
                continue;
            }
            labelInfo.setCommitState(CommitState.FAILED);
            labelInfo.setCommitMessage("Label ID not licenced");
        }
    }

    public void delete(Collection<LabelInfo> records, UserId user, Transaction<?> transaction) throws DatasetException {
        Iterator<LabelInfo> i$ = records.iterator();
        while (i$.hasNext()) {
            LabelInfo labelInfo;
            boolean result = this.unregisterLabel((labelInfo = i$.next()).getLabelId(), user, transaction);
            labelInfo.setCommitState(result ? CommitState.DELETED : CommitState.FAILED);
        }
    }

    public boolean isLicenced(LabelId labelId) {
        return this.featureUnlock.isLabelAllowed(labelId.toAddress(), labelId.getLabelType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(LabelId labelId) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            return this.registeredLabelInfos.containsKey(labelId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatteryStatus(LabelId labelId, CalculatedPowerStatus batteryStatus) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
            if (labelInfo != null) {
                labelInfo.setCalculatedPowerStatus(batteryStatus);
                labelInfo.setPowerStatus(batteryStatus.getPowerStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastUpdateInfo(LabelId labelId, UpdateInfo updateInfo) {
        if (Config.isIgnoreArchiveTasksForUpdateStatusQueries() && updateInfo != null && updateInfo.getInternal() != null && updateInfo.getInternal().booleanValue()) {
            return;
        }
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
            if (labelInfo != null) {
                labelInfo.setUpdateInfo(updateInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastShownImage(LabelId labelId, UpdateImage updateImage) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
            if (labelInfo != null) {
                labelInfo.setLastShownImage(updateImage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadRegisteredLabels(Transaction<?> transaction) throws DatasetException, SerializeException {
        ORMTransaction<RegisteredLabel> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Criteria criteria = ormTransaction.createCriteria(RegisteredLabel.class);
        criteria.addOrder(Order.asc((String)"id"));
        List registeredLabels = ormTransaction.query(criteria, RegisteredLabel.class);
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            TreeMap<LabelId, LabelInfo> newRegisteredLabelInfos = new TreeMap<LabelId, LabelInfo>();
            this.registeredLabels.clear();
            for (RegisteredLabel registeredLabel : registeredLabels) {
                LabelId labelId = registeredLabel.toLabelId();
                if (!this.isLicenced(labelId)) continue;
                LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
                if (labelInfo != null) {
                    labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
                    labelInfo.setTags(registeredLabel.getTags());
                    if (registeredLabel.getPin() != null) {
                        labelInfo.setPin(registeredLabel.getPin());
                    }
                } else {
                    labelInfo = new LabelInfo(labelId, registeredLabel.getPin(), registeredLabel.getTags());
                }
                newRegisteredLabelInfos.put(labelId, labelInfo);
                this.registeredLabels.put(labelId, registeredLabel);
            }
            this.registeredLabelInfos.clear();
            this.registeredLabelInfos.putAll(newRegisteredLabelInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerLabel(LabelId labelId, Pin pin, Set<String> tags, UserId user, Transaction<?> transaction) throws DatasetException {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            if (this.isLicenced(labelId)) {
                RegisteredLabel registeredLabel = (RegisteredLabel)this.registeredLabels.get(labelId);
                LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
                if (registeredLabel == null) {
                    if (this.registeredLabelInfos.size() >= this.featureUnlock.getMaxLabelsAllowed()) {
                        return false;
                    }
                    registeredLabel = new RegisteredLabel(labelId, pin, tags);
                } else {
                    if (pin != null) {
                        registeredLabel.setPin(pin);
                    }
                    registeredLabel.addTags(tags);
                }
                if (labelInfo == null) {
                    labelInfo = new LabelInfo(labelId, pin, tags);
                } else {
                    if (pin != null) {
                        labelInfo.setPin(pin);
                        labelInfo.setSecurityStatus(SecurityStatus.UNKNOWN);
                    }
                    labelInfo.addTags(tags);
                }
                this.registeredLabelDataset.store((Commitable)registeredLabel, user, transaction);
                this.registeredLabels.put(labelId, registeredLabel);
                this.registeredLabelInfos.put(labelId, labelInfo);
                for (LabelRegisterListener listener : this.labelRegisterListeners) {
                    listener.registerLabel(labelId, pin);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterLabel(LabelId labelId, UserId user, Transaction<?> transaction) throws DatasetException {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            RegisteredLabel labelToUnregister = this.queryRegisteredLabel(labelId, transaction);
            if (labelToUnregister != null) {
                this.registeredLabels.remove(labelId);
                this.registeredLabelDataset.delete((Commitable)labelToUnregister, user, transaction);
            }
            for (LabelRegisterListener listener : this.labelRegisterListeners) {
                listener.unregisterLabel(labelId);
            }
            this.registeredLabelInfos.remove(labelId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignTags(LabelId labelId, Set<String> tags, UserId user, Transaction<?> transaction) throws DatasetException {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            if (this.isLicenced(labelId) && this.isRegistered(labelId)) {
                LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
                Set labelTags = labelInfo.getTags();
                labelTags.addAll(tags);
                RegisteredLabel registeredLabel = (RegisteredLabel)this.registeredLabels.get(labelId);
                registeredLabel.setTags(labelTags);
                this.registeredLabelDataset.store((Commitable)registeredLabel, user, transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTags(LabelId labelId, Set<String> tags, UserId user, Transaction<?> transaction) throws DatasetException {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            if (this.isLicenced(labelId) && this.isRegistered(labelId)) {
                LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
                Set labelTags = labelInfo.getTags();
                labelTags.removeAll(tags);
                RegisteredLabel registeredLabel = (RegisteredLabel)this.registeredLabels.get(labelId);
                registeredLabel.setTags(labelTags);
                this.registeredLabelDataset.store((Commitable)registeredLabel, user, transaction);
            }
        }
    }

    private RegisteredLabel queryRegisteredLabel(LabelId labelId, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select r from RegisteredLabel r where label = :label").setParameter("label", (Object)labelId.getId());
        return ormTransaction.querySingleRow(query, RegisteredLabel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showConnectionStatusAsUnknown(boolean showAsUnknown) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            this.showConnectionStatusAsUnknown = showAsUnknown;
        }
    }

    public void removePin(LabelId labelId) throws DatasetException {
        Transaction transaction = this.transactionSupplier.newTransaction();
        try {
            this.removePin(labelId, transaction);
            transaction.commit();
        }
        catch (DatasetException e) {
            transaction.rollback();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePin(LabelId labelId, Transaction<?> transaction) throws DatasetException {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
            RegisteredLabel registeredLabel = (RegisteredLabel)this.registeredLabels.get(labelId);
            if (labelInfo != null && labelInfo.hasPin()) {
                logger.info("Removing PIN for label %s", new Object[]{labelId});
                labelInfo.removePin();
            }
            if (registeredLabel != null && registeredLabel.hasPin()) {
                registeredLabel.removePin();
                this.registeredLabelDataset.store((Commitable)registeredLabel, UserId.SYSTEM, transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedWakeup(WakeupStatistic wakeupStatistic) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            LabelId labelId = new LabelId(wakeupStatistic.getLabelAddress());
            LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
            if (labelInfo != null) {
                Version firmware = wakeupStatistic.getFirmwareVersion();
                boolean keyUnset = wakeupStatistic.isKeyUnset();
                boolean keysNotProgrammed = wakeupStatistic.areKeysNotProgrammed();
                boolean hasPin = labelInfo.hasPin();
                labelInfo.setFirmwareVersion(firmware);
                labelInfo.setSecurityStatus(SecurityStatus.valueOf((Version)firmware, (boolean)keyUnset, (boolean)keysNotProgrammed, (boolean)hasPin));
                labelInfo.setCurrentPage(wakeupStatistic.getCurrentPage());
                labelInfo.setInternalPowerStatus(wakeupStatistic.getPowerStatus());
                if (!Config.isBatteryStatusClassificationEnabled()) {
                    labelInfo.setPowerStatus(wakeupStatistic.getPowerStatus());
                }
                labelInfo.setLabelErrors(wakeupStatistic.getLabelErrors());
                labelInfo.setSyncQuality(wakeupStatistic.getSyncQuality());
                labelInfo.setRssi(wakeupStatistic.getLastRssi());
                labelInfo.setLqi(wakeupStatistic.getLastLqi());
                labelInfo.setAccessPointId(Integer.valueOf(wakeupStatistic.getAccessPointId()));
                if (wakeupStatistic.getLastPingReplyTime() != null) {
                    labelInfo.setWakeupTime(wakeupStatistic.getLastPingReplyTime());
                }
                if (Config.isPersistLabelInfoHistory()) {
                    this.persistLabelInfoCache.addToCache(labelInfo);
                }
                if (!keyUnset) {
                    try {
                        this.removePin(labelId);
                    }
                    catch (DatasetException exc) {
                        logger.error("Failed to remove PIN for label %s", new Object[]{labelId.getLabelIdString()});
                        logger.logException((Throwable)exc);
                    }
                }
            }
        }
    }

    public void receivedJoinRequest(JoinRequest joinRequest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLabelRegisterListener(LabelRegisterListener listener) {
        this.labelRegisterListeners.add(listener);
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            for (LabelInfo labelInfo : this.registeredLabelInfos.values()) {
                listener.registerLabel(labelInfo.getLabelId(), labelInfo.getPin());
            }
        }
    }

    public void unregisterLabelRegisterListener(LabelRegisterListener listener) {
        this.labelRegisterListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getTagsForLabel(LabelId labelId) {
        SortedMap<LabelId, LabelInfo> sortedMap = this.registeredLabelInfos;
        synchronized (sortedMap) {
            LabelInfo labelInfo = (LabelInfo)this.registeredLabelInfos.get(labelId);
            return labelInfo != null ? labelInfo.getTags() : Collections.emptySet();
        }
    }

    public void close() {
    }

    @Override
    public void licenseReloaded(Transaction<?> transaction) {
        try {
            this.reloadRegisteredLabels(transaction);
        }
        catch (SerializeException exc) {
            logger.warn("Could not reload registered labels after license change: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (DatasetException exc) {
            logger.warn("Could not reload registered labels after license change: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }
}

