/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.FontRecord;
import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.text.ESLFontLoader;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FontDataset
extends AbstractDataset<FontRecord> {
    static ESLLogger logger = ESLLogger.getLogger(FontDataset.class);
    public static final String TEMPLATE_EXTENSION = "xsl";
    private List<FontRecord> fontRecords = new ArrayList<FontRecord>();
    private final ESLFontLoader fontLoader = new ESLFontLoader(new File(Config.getFontsPath()));

    public FontDataset(Map<Role, DatasetPermissions> datasetPermissions) throws DatasetException, InitializationException {
        super(FontRecord.class, datasetPermissions);
    }

    public FontRecord queryById(long id, Transaction<?> transaction) throws DatasetException {
        throw new DatasetException("Query by ID not implemented", new Object[0]);
    }

    public synchronized List<FontRecord> queryAll(Transaction<?> transaction) throws DatasetException {
        return Collections.unmodifiableList(new ArrayList<FontRecord>(this.fontRecords));
    }

    public synchronized int getRecordCount(Transaction<?> transaction) {
        return this.fontRecords.size();
    }

    public void store(Collection<FontRecord> records, UserId user, Transaction<?> transaction) {
    }

    public void delete(Collection<FontRecord> records, UserId user, Transaction<?> transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Abortable reload(Transaction<?> transaction) throws DatasetException {
        logger.debug("Reloading fonts");
        Map loadedFonts = this.fontLoader.loadFonts();
        HashSet<FontRecord> fontSet = new HashSet<FontRecord>();
        int fontIndex = 0;
        for (Map.Entry entry : loadedFonts.entrySet()) {
            fontSet.add(new FontRecord((long)fontIndex, ((Font)entry.getValue()).getName(), (File)entry.getKey(), ((Font)entry.getValue()).getFamily()));
            ++fontIndex;
        }
        try {
            Font[] fonts;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : fonts = graphicsEnvironment.getAllFonts()) {
                fontSet.add(new FontRecord((long)fontIndex, font.getName(), null, font.getFamily()));
                ++fontIndex;
            }
        }
        catch (Exception exc) {
            logger.warn("Error loading installed fonts: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        FontDataset fontDataset = this;
        synchronized (fontDataset) {
            this.fontRecords.clear();
            this.fontRecords.addAll(fontSet);
            Collections.sort(this.fontRecords, new Comparator<FontRecord>(){

                @Override
                public int compare(FontRecord o1, FontRecord o2) {
                    return o1.getIdentifier().compareTo(o2.getIdentifier());
                }
            });
        }
        this.notifyRecordsModified(fontSet, transaction);
        return Abortable.DO_NOTHING;
    }

    public void close() {
    }
}

