/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.core.AccessPointUpdateStatus;
import at.mrdevelopment.esl.core.AccessPointUpdateType;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.DefaultORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdateRecord;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;

public class AccessPointUpdateDataset
extends DefaultORMDataset<AccessPointUpdateRecord> {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointUpdateDataset.class);

    public AccessPointUpdateDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(AccessPointUpdateRecord.class, datasetPermissions);
    }

    public int cleanupHistory(int daysToKeep, int maxCleanupRecords) throws DatasetException {
        return 0;
    }

    public Collection<AccessPointUpdateRecord> queryUnfinishedSoftwareUpdates(Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select a from AccessPointUpdateRecord a where a.status in " + AccessPointUpdateStatus.UNFINISHED_SQL + " and a.updateType in " + AccessPointUpdateType.SOFTWARE_UPDATE_SQL);
        List<AccessPointUpdateRecord> result = ormTransaction.query(query, AccessPointUpdateRecord.class);
        return result;
    }

    public List<AccessPointUpdateRecord> queryByAccessPointIdAndHash(Integer accessPointId, byte[] updateHash, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("select a from AccessPointUpdateRecord a where a.accessPointId = :accessPointId and a.updateHash = :updateHash").setInteger("accessPointId", accessPointId.intValue()).setBinary("updateHash", updateHash);
        List<AccessPointUpdateRecord> result = ormTransaction.query(query, AccessPointUpdateRecord.class);
        return result;
    }
}

