/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceController;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceManager;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceStatus;
import at.mrdevelopment.esl.accesspoint.controller.AccessPointInfoHolder;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.util.AccessPointUpdate;
import at.mrdevelopment.esl.persistence.record.AbstractDataset;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.HttpServiceClientConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;

public class AccessPointInfoDataset
extends AbstractDataset<AccessPointInfo>
implements AccessPointServiceManager,
AccessPointInfoHolder {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointInfoDataset.class);
    private final SortedMap<Integer, AccessPointInfo> accessPointInfos = new TreeMap<Integer, AccessPointInfo>();
    private final Map<Integer, AccessPointService> accessPoints = new HashMap<Integer, AccessPointService>();
    private final Object lock = new Object();
    private final FeatureUnlock featureUnlock;
    private final List<DiscoveryModule> discoveryModules;
    private AccessPointServiceController accessPointServiceController;

    public AccessPointInfoDataset(FeatureUnlock featureUnlock) throws InitializationException {
        super(AccessPointInfo.class, DatasetPermissions.QUERY_PERMISSIONS);
        this.featureUnlock = featureUnlock;
        this.discoveryModules = new LinkedList<DiscoveryModule>();
    }

    public void setAccessPointServiceController(AccessPointServiceController accessPointServiceController) {
        this.accessPointServiceController = accessPointServiceController;
    }

    public void addDiscoveryModule(DiscoveryModule module) {
        this.discoveryModules.add(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPointInfo queryById(long id, Transaction<?> transaction) throws DatasetException {
        Object object = this.lock;
        synchronized (object) {
            return (AccessPointInfo)this.accessPointInfos.get((int)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessPointInfo> queryAll(Transaction<?> transaction) throws DatasetException {
        LinkedList<AccessPointInfo> resultList = new LinkedList<AccessPointInfo>();
        TreeSet<Integer> apIdSet = new TreeSet<Integer>();
        Object object = this.lock;
        synchronized (object) {
            for (AccessPointInfo ap : this.accessPointInfos.values()) {
                apIdSet.add(ap.getAccessPointId());
                resultList.add(ap);
            }
        }
        for (DiscoveryModule module : this.discoveryModules) {
            List<AccessPointInfo> discoveredAps = module.getDiscoveredAccessPoints();
            for (AccessPointInfo ap : discoveredAps) {
                if (apIdSet.contains(ap.getAccessPointId())) continue;
                resultList.add(ap);
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount(Transaction<?> transaction) throws DatasetException {
        Object object = this.lock;
        synchronized (object) {
            return this.accessPointInfos.size();
        }
    }

    public void store(Collection<AccessPointInfo> records, UserId user, Transaction<?> transaction) throws DatasetException {
    }

    public void delete(Collection<AccessPointInfo> records, UserId user, Transaction<?> transaction) throws DatasetException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            for (AccessPointService service : this.accessPoints.values()) {
                service.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceStatus(AccessPointServiceStatus serviceStatus) {
        Object object = this.lock;
        synchronized (object) {
            AccessPointService service;
            int accessPointId = serviceStatus.getAccessPointId();
            AccessPointInfo accessPointInfo = (AccessPointInfo)this.accessPointInfos.get(accessPointId);
            if (accessPointInfo != null && (service = this.accessPoints.get(accessPointId)) != null) {
                accessPointInfo.setConnectionStatus(serviceStatus.getConnectionStatus());
                accessPointInfo.setServiceStatus(serviceStatus);
                String protocol = service.getProtocol().getName();
                if (serviceStatus.getProtocolTLSEnabled()) {
                    protocol = protocol.replace("TCP", "TCP/TLS");
                }
                accessPointInfo.setProtocol(protocol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessPointOffline(int accessPointId) {
        Object object = this.lock;
        synchronized (object) {
            AccessPointInfo accessPointInfo = (AccessPointInfo)this.accessPointInfos.get(accessPointId);
            if (accessPointInfo != null) {
                accessPointInfo.setConnectionStatus(ConnectionStatus.OFFLINE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AccessPointService> getAccessPoints() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<AccessPointService>(this.accessPoints.values());
        }
    }

    public AccessPointServiceManager getConfiguredAndLicensedAccessPointManager() {
        return this.getLicensedAccessPointManager(ConnectionStatus.OFFLINE, ConnectionStatus.ONLINE);
    }

    public AccessPointServiceManager getOnlineAndLicensedAccessPointManager() {
        return this.getLicensedAccessPointManager(ConnectionStatus.ONLINE);
    }

    private AccessPointServiceManager getLicensedAccessPointManager(final ConnectionStatus ... connectionStatus) {
        return new AccessPointServiceManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<AccessPointService> getAccessPoints() {
                Object object = AccessPointInfoDataset.this.lock;
                synchronized (object) {
                    ArrayList<AccessPointService> onlineAccessPoints = new ArrayList<AccessPointService>();
                    for (AccessPointInfo accessPointInfo : AccessPointInfoDataset.this.accessPointInfos.values()) {
                        AccessPointService accessPointService;
                        AccessPointType type = AccessPointTypeMapping.getType((int)accessPointInfo.getAccessPointId());
                        if (!AccessPointInfoDataset.this.featureUnlock.isAccessPointTypeAllowed(type) || !ArrayUtils.contains((Object[])connectionStatus, (Object)accessPointInfo.getConnectionStatus()) || (accessPointService = (AccessPointService)AccessPointInfoDataset.this.accessPoints.get(accessPointInfo.getAccessPointId())) == null) continue;
                        onlineAccessPoints.add(accessPointService);
                    }
                    int toIndex = Math.min(AccessPointInfoDataset.this.featureUnlock.getMaxAccessPointsAllowed(), onlineAccessPoints.size());
                    return onlineAccessPoints.subList(0, toIndex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnline(int accessPointId) {
        Object object = this.lock;
        synchronized (object) {
            AccessPointInfo accessPointInfo = (AccessPointInfo)this.accessPointInfos.get(accessPointId);
            if (accessPointInfo == null) {
                return false;
            }
            return accessPointInfo.isOnline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPointService getService(int accessPointId) {
        Object object = this.lock;
        synchronized (object) {
            return this.accessPoints.get(accessPointId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessPointServiceStatus getServiceStatus(int accessPointId) {
        Object object = this.lock;
        synchronized (object) {
            return ((AccessPointInfo)this.accessPointInfos.get(accessPointId)).getServiceStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAccessPointServices() {
        Object object = this.lock;
        synchronized (object) {
            EnvCreationStatus status = EnvCreationStatus.NOT_YET_TRIED_CREATION;
            EnvironmentProperties envProperties = null;
            boolean thinModeEnabled = Config.isAccessPointUseThinMode();
            boolean lancomUseTcpThinMode = Config.getLancomUseTcpThinMode();
            for (AccessPointInfo apInfo : this.accessPointInfos.values()) {
                if (!apInfo.isServiceToBeInitialized() || apInfo.isServiceInitialized()) continue;
                if (status == EnvCreationStatus.NOT_YET_TRIED_CREATION) {
                    try {
                        envProperties = new EnvironmentProperties(false);
                        status = EnvCreationStatus.SUCCESS;
                    }
                    catch (InitializationException ie) {
                        status = EnvCreationStatus.FAILURE;
                    }
                    if (status == EnvCreationStatus.FAILURE) break;
                }
                try {
                    apInfo.setAddress(apInfo.getAddress().replace("localhost", envProperties.getIPAddress()));
                    ServiceAddress newAddress = ServiceAddress.fromString((String)apInfo.getApAddress());
                    if (!newAddress.isValid()) continue;
                    AccessPointService accessPointService = AccessPointTypeMapping.getType((int)apInfo.getAccessPointId()) == AccessPointType.LANCOM ? this.accessPointServiceController.createAccessPointService(apInfo.getAccessPointId(), newAddress, false, lancomUseTcpThinMode) : this.accessPointServiceController.createAccessPointService(apInfo.getAccessPointId(), newAddress, false, thinModeEnabled);
                    this.accessPoints.put(apInfo.getAccessPointId(), accessPointService);
                    apInfo.setServiceInitialized(true);
                    apInfo.setProtocol(accessPointService.getProtocol().getName());
                }
                catch (MalformedURLException me) {
                    logger.error("Failed to add access point %d at %s", new Object[]{apInfo.getAccessPointId(), apInfo.getApAddress()});
                    logger.logException((Throwable)me);
                }
                catch (InitializationException exc) {
                    logger.error("Failed to add access point %d at %s", new Object[]{apInfo.getAccessPointId(), apInfo.getApAddress()});
                    logger.logException((Throwable)exc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOfflineAccessPointAddress(int accessPointId, ServiceAddress serviceAddress, boolean canUpdate, boolean thinModeEnabled) {
        Object object = this.lock;
        synchronized (object) {
            AccessPointInfo apInfo = (AccessPointInfo)this.accessPointInfos.get(accessPointId);
            if (apInfo == null) {
                apInfo = AccessPointInfo.createOffline((int)accessPointId, (ServiceAddress)this.accessPointServiceController.getServiceAddress(accessPointId, serviceAddress, thinModeEnabled), (ServiceAddress)serviceAddress, (ServiceAddress)this.accessPointServiceController.getManagementAddress(accessPointId, serviceAddress), (Boolean)canUpdate);
                this.accessPointInfos.put(accessPointId, apInfo);
            } else {
                String address = apInfo.getAddress();
                if (!address.equals(serviceAddress.toString())) {
                    logger.info("Updating OFFLINE AccessPointInfo for AP-ID = %d.", new Object[]{accessPointId});
                    apInfo.setAddress(this.accessPointServiceController.getServiceAddress(accessPointId, serviceAddress, thinModeEnabled).toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessPoint(AccessPointUpdate update) {
        int apId = update.getAccessPointId();
        Object object = this.lock;
        synchronized (object) {
            AccessPointInfo apInfo = (AccessPointInfo)this.accessPointInfos.get(apId);
            if (apInfo == null) {
                apInfo = AccessPointInfo.createOffline((int)apId, (ServiceAddress)this.accessPointServiceController.getServiceAddress(apId, update.getServiceAddress(), update.isThinModeEnabled()), (ServiceAddress)update.getServiceAddress(), (ServiceAddress)this.accessPointServiceController.getManagementAddress(apId, update.getServiceAddress()), (Boolean)update.isAutoConfigEnabled());
                this.accessPointInfos.put(apId, apInfo);
            }
            apInfo.setServiceToBeInitialized(update.isServiceToBeInitialized());
            logger.info("Updating AccessPointService for AP-ID = %d.", new Object[]{apId});
            AccessPointService accessPointService = this.accessPoints.get(apId);
            if (accessPointService != null) {
                accessPointService.shutdown();
                this.accessPoints.remove(update.getAccessPointId());
                this.accessPointServiceController.removeAccessPoint(update.getAccessPointId());
            }
            try {
                accessPointService = this.accessPointServiceController.createAccessPointService(update.getAccessPointId(), update.getServiceAddress(), update.isPermanentlyOffline(), update.isThinModeEnabled());
                this.accessPoints.put(apId, accessPointService);
                apInfo.setServiceInitialized(true);
                apInfo.setProtocol(accessPointService.getProtocol().getName());
                apInfo.setAddress(this.accessPointServiceController.getServiceAddress(apId, update.getServiceAddress(), update.isThinModeEnabled()).toString());
                apInfo.setApAddress(update.getServiceAddress().toString());
                ServiceAddress managementAddress = this.accessPointServiceController.getManagementAddress(apId, update.getServiceAddress());
                apInfo.setManagementAddress(managementAddress != null ? managementAddress.toString() : "");
            }
            catch (InitializationException exc) {
                apInfo.setServiceInitialized(false);
                logger.error("Failed to add access point %d at %s", new Object[]{apId, update.getServiceAddress()});
                logger.logException((Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessPointService(int accessPointId) {
        Object object = this.lock;
        synchronized (object) {
            AccessPointService accessPointService = this.accessPoints.get(accessPointId);
            if (accessPointService != null) {
                accessPointService.shutdown();
                this.accessPoints.remove(accessPointId);
            }
            this.accessPointServiceController.removeAccessPoint(accessPointId);
            AccessPointInfo accessPointInfo = (AccessPointInfo)this.accessPointInfos.get(accessPointId);
            if (accessPointInfo != null) {
                accessPointInfo.setConnectionStatus(ConnectionStatus.OFFLINE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessPoint(int accessPointId) {
        Object object = this.lock;
        synchronized (object) {
            AccessPointService accessPointService = this.accessPoints.remove(accessPointId);
            if (accessPointService != null) {
                accessPointService.shutdown();
            }
            this.accessPointInfos.remove(accessPointId);
            this.accessPointServiceController.removeAccessPoint(accessPointId);
        }
    }

    public HttpServiceClientConfiguration getHttpConfiguration() throws InitializationException {
        return this.accessPointServiceController.getHttpConfiguration();
    }

    public void setLocalPort(Integer apId, Integer port) {
        AccessPointInfo info = (AccessPointInfo)this.accessPointInfos.get(apId);
        if (info != null) {
            info.setLocalPort(port);
        }
    }

    private static enum EnvCreationStatus {
        NOT_YET_TRIED_CREATION,
        SUCCESS,
        FAILURE;

    }
}

