/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.dataset;

import at.mrdevelopment.esl.authentication.DatasetPermissions;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.AccessPointRegistration;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.KeepDeletedORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.server.AccessPointListener;
import at.mrdevelopment.esl.server.LabelRegisterListener;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;

public class AccessPointConfigurationDataset
extends KeepDeletedORMDataset<AccessPointConfiguration> {
    private final Set<AccessPointListener> listeners = new HashSet<AccessPointListener>();

    public AccessPointConfigurationDataset(Map<Role, DatasetPermissions> datasetPermissions) throws InitializationException, DatasetException {
        super(AccessPointConfiguration.class, datasetPermissions);
    }

    @Override
    protected String getDefaultOrderClause() {
        return " order by t.accessPointId";
    }

    public AccessPointConfiguration queryByAccessPointId(int accessPointId, Transaction<?> transaction) throws DatasetException {
        ORMTransaction<?> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createQuery("from AccessPointConfiguration c where c.accessPointId = :accessPointId and c.deleted = false").setParameter("accessPointId", (Object)accessPointId);
        return ormTransaction.querySingleRow(query, AccessPointConfiguration.class);
    }

    @Override
    public void store(Collection<AccessPointConfiguration> records, UserId user, Transaction<?> transaction) throws DatasetException {
        if (this.containsDuplicates(records)) {
            throw new DatasetException(String.format("Access Point collection contains duplicate entries", new Object[0]), new Object[0]);
        }
        for (AccessPointConfiguration accessPointConfiguration : records) {
            if (!accessPointConfiguration.isNewRecord() || this.queryByAccessPointId(accessPointConfiguration.getAccessPointId(), transaction) == null) continue;
            throw new DatasetException(String.format("Access Point with ID %d already registered", accessPointConfiguration.getAccessPointId()), new Object[0]);
        }
        this.storeInternal(records, user, transaction);
    }

    private void storeInternal(Collection<AccessPointConfiguration> records, UserId user, Transaction<?> transaction) throws DatasetException {
        super.store(records, user, transaction);
        this.notifyAccessPointsAdded(records);
    }

    @Override
    public void delete(Collection<AccessPointConfiguration> records, UserId user, Transaction<?> transaction) throws DatasetException {
        super.delete(records, user, transaction);
        this.notifyAccessPointsRemoved(records);
    }

    public void registerAccessPointListener(AccessPointListener listener, Transaction<?> transaction) throws DatasetException {
        List<AccessPointConfiguration> accessPointConfigurations = this.queryAll(transaction);
        boolean changeHappened = false;
        for (AccessPointConfiguration apc : accessPointConfigurations) {
            changeHappened |= apc.init();
        }
        if (changeHappened) {
            this.storeInternal(accessPointConfigurations, UserId.SYSTEM, transaction);
        }
        this.notifyAccessPointsAdded(listener, accessPointConfigurations);
        this.listeners.add(listener);
    }

    public void unregisterAccessPointListener(LabelRegisterListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAccessPointsAdded(Collection<AccessPointConfiguration> records) {
        for (AccessPointListener listener : this.listeners) {
            this.notifyAccessPointsAdded(listener, records);
        }
    }

    private void notifyAccessPointsAdded(AccessPointListener listener, Collection<AccessPointConfiguration> records) {
        for (AccessPointConfiguration configuration : records) {
            Integer accessPointId = configuration.getAccessPointId();
            if (accessPointId == null) continue;
            String host = configuration.getAddress();
            int port = configuration.getPort();
            boolean ssl = Config.isAccessPointSsl();
            ServiceAddress serviceAddress = new ServiceAddress(ssl, host, port);
            listener.addAccessPoint(accessPointId, serviceAddress, configuration.isAutoConfig());
        }
    }

    private void notifyAccessPointsRemoved(Collection<AccessPointConfiguration> records) {
        for (AccessPointListener listener : this.listeners) {
            this.notifyAccessPointsRemoved(listener, records);
        }
    }

    private void notifyAccessPointsRemoved(AccessPointListener listener, Collection<AccessPointConfiguration> records) {
        for (AccessPointConfiguration configuration : records) {
            if (configuration.getAccessPointId() == null) continue;
            listener.removeAccessPoint(configuration.getAccessPointId());
        }
    }

    public void registerAccessPoint(AccessPointRegistration accessPointRegistration, UserId user, Transaction<?> transaction) throws DatasetException {
        AccessPointConfiguration newRecord;
        AccessPointConfiguration existingRecord = this.queryByAccessPointId(accessPointRegistration.getAccessPointId(), transaction);
        if (existingRecord != null) {
            throw new DatasetException("Access point with ID %d already registered", new Object[]{accessPointRegistration.getAccessPointId()});
        }
        AccessPointRegistration.Configuration configuration = accessPointRegistration.getConfiguration();
        if (configuration.isValid(accessPointRegistration.getAccessPointId())) {
            newRecord = AccessPointConfiguration.fromAccessPointRegistration((AccessPointRegistration)accessPointRegistration);
            if (newRecord.getAddress() == null) {
                newRecord.setAddress("");
            }
        } else {
            throw new DatasetException("Invalid access point configuration", new Object[0]);
        }
        this.storeInternal(Collections.singleton(newRecord), user, transaction);
    }

    public void unregisterAccessPoint(int accessPointId, UserId user, Transaction<?> transaction) throws DatasetException {
        AccessPointConfiguration record = this.queryByAccessPointId(accessPointId, transaction);
        if (record != null) {
            this.delete((Collection<AccessPointConfiguration>)Collections.singleton(record), user, transaction);
        }
    }

    public void updateAccessPoint(int accessPointId, AccessPointRegistration.Configuration configuration, UserId user, Transaction<?> transaction) throws DatasetException {
        AccessPointConfiguration record = this.queryByAccessPointId(accessPointId, transaction);
        if (record == null) {
            throw new DatasetException("Invalid access point %d", new Object[]{accessPointId});
        }
        if (!record.updateConfiguration(accessPointId, configuration)) {
            throw new DatasetException("Invalid access point configuration", new Object[0]);
        }
        this.storeInternal(Collections.singleton(record), user, transaction);
    }

    private boolean containsDuplicates(Collection<AccessPointConfiguration> records) {
        HashSet<Integer> accessPointIds = new HashSet<Integer>();
        for (AccessPointConfiguration accessPointConfiguration : records) {
            accessPointIds.add(accessPointConfiguration.getAccessPointId());
        }
        return accessPointIds.size() != records.size();
    }
}

