/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey.security;

import at.mrdevelopment.esl.jersey.security.TokenPrincipal;
import at.mrdevelopment.toolkit.authentication.UserId;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.apache.http.auth.BasicUserPrincipal;

public class JerseySecurityContext
implements SecurityContext {
    private final UserId userId;
    private final Principal principal;

    public JerseySecurityContext(Principal principal, UserId userId) {
        this.principal = principal;
        this.userId = userId;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String roleString) {
        return this.userId.getRole().toString().equals(roleString);
    }

    public boolean isSecure() {
        return this.userId.isAuthorized();
    }

    public String getAuthenticationScheme() {
        if (this.principal instanceof BasicUserPrincipal) {
            return "BASIC";
        }
        if (this.principal instanceof TokenPrincipal) {
            return "TOKEN";
        }
        return null;
    }

    public UserId getUserId() {
        return this.userId;
    }
}

