/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey.security;

import at.mrdevelopment.esl.authentication.TokenAuthUtils;
import at.mrdevelopment.esl.authentication.TokenAuthenticator;
import at.mrdevelopment.esl.authentication.UserAuthenticator;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.configuration.ConfigurationChangedListener;
import at.mrdevelopment.esl.configuration.ConfigurationStorage;
import at.mrdevelopment.esl.jersey.FilterPriority;
import at.mrdevelopment.esl.jersey.JerseyResourceConfig;
import at.mrdevelopment.esl.jersey.security.ApiTokenUtils;
import at.mrdevelopment.esl.jersey.security.JerseySecurityContext;
import at.mrdevelopment.esl.jersey.security.MethodBasedRoleAuthorization;
import at.mrdevelopment.esl.jersey.security.RoleAuthorization;
import at.mrdevelopment.esl.jersey.security.TokenPrincipal;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.DatasetModifiedListener;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.dataset.UserDataset;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.toolkit.NetworkAddress;
import at.mrdevelopment.toolkit.NetworkAddressUtils;
import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.BasicAuthUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.collect.Sets;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.glassfish.grizzly.http.server.Request;

@FilterPriority(value=1)
public class ApiSecurityManager
implements DatasetModifiedListener<User>,
ContainerRequestFilter,
ConfigurationChangedListener {
    static ESLLogger logger = ESLLogger.getLogger(ApiSecurityManager.class);
    private static final String REALM = "SES-imagotag Core Service";
    private static final Set<String> LOCALHOST_ADDRESSES = Sets.newHashSet((Object[])new String[]{"localhost", "127.0.0.1", "0:0:0:0:0:0:0:1"});
    private final UserDataset userDataset;
    private final UserAuthenticator basicAuthenticator;
    private final TokenAuthenticator tokenAuthenticator;
    private final RoleAuthorization roleAuthorization;
    private Collection<NetworkAddress> allowedAddresses = new HashSet<NetworkAddress>();
    private final Object allowedAddressLock = new Object();
    private final boolean blockLocalhost;
    @Context
    private ThreadLocal<Request> httpRequest;

    public ApiSecurityManager(TransactionSupplier transactionSupplier, UserDataset userDataset, ConfigurationStorage configurationStorage, JerseyResourceConfig resourceConfig, boolean blockLocalhost) throws DatasetException {
        this.userDataset = userDataset;
        this.blockLocalhost = blockLocalhost;
        this.basicAuthenticator = new UserAuthenticator(transactionSupplier, userDataset, true);
        this.tokenAuthenticator = new TokenAuthenticator(transactionSupplier, userDataset);
        this.roleAuthorization = new MethodBasedRoleAuthorization();
        this.userDataset.addDatasetModifiedListener(this);
        configurationStorage.addConfigurationChangedListener(this);
        resourceConfig.addRequestFilter(this);
    }

    public void init(Transaction<?> transaction) throws DatasetException {
        this.recordsModified(this.userDataset.queryAll(transaction), transaction);
        this.parseAllowedAddresses();
    }

    public void recordsModified(Collection<User> records, Transaction<?> transaction) {
        for (User user : records) {
            if (user.getApiToken() != null && !user.getApiToken().trim().isEmpty()) continue;
            this.generateNewToken(user, transaction);
        }
    }

    private void generateNewToken(User user, Transaction<?> transaction) {
        String newToken = ApiTokenUtils.generateNewToken();
        user.setApiToken(newToken);
        try {
            this.userDataset.store((Commitable)user, User.SYSTEM, transaction);
        }
        catch (DatasetException exc) {
            logger.warn("Could not store new API token for user %s: %s", new Object[]{user.getName(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (!this.blockLocalhost && this.isLocalhost()) {
            return request;
        }
        if (!this.isValidRemoteAddress()) {
            this.respondForbidden(request);
        }
        if (!Config.isApiSecurityEnabled()) {
            return request;
        }
        String authorizationHeader = request.getHeaderValue("Authorization");
        if (authorizationHeader == null || authorizationHeader.trim().isEmpty()) {
            this.respondUnauthorized(request);
        }
        JerseySecurityContext securityContext = this.authorizeToken(authorizationHeader);
        request.setSecurityContext((SecurityContext)securityContext);
        if (securityContext == null || !securityContext.getUserId().isAuthorized()) {
            securityContext = this.authorizeBasic(authorizationHeader);
            if (securityContext != null) {
                request.setSecurityContext((SecurityContext)securityContext);
            }
            if (securityContext == null || !securityContext.getUserId().isAuthorized()) {
                this.respondUnauthorized(request);
            }
        }
        if (!this.isRoleAuthorized(securityContext.getUserId(), request)) {
            this.respondUnauthorized(request);
        }
        return request;
    }

    public JerseySecurityContext authorizeToken(String authorizationHeader) {
        String userToken = TokenAuthUtils.parseToken(authorizationHeader);
        if (userToken == null) {
            return null;
        }
        UserId userId = TokenAuthUtils.authorizeWithToken(userToken, this.tokenAuthenticator);
        return new JerseySecurityContext(new TokenPrincipal(userId.getUsername(), userToken), userId);
    }

    public JerseySecurityContext authorizeBasic(String authorizationHeader) {
        UsernamePasswordCredentials credentials = BasicAuthUtils.parseCredentials((String)authorizationHeader);
        if (credentials == null) {
            return null;
        }
        UserId userId = BasicAuthUtils.authorize((String)credentials.getUserName(), (String)credentials.getPassword(), (Authenticator)this.basicAuthenticator);
        return new JerseySecurityContext(credentials.getUserPrincipal(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidRemoteAddress() {
        if (Config.isApiSecurityAllowedAddressesEnabled()) {
            Object object = this.allowedAddressLock;
            synchronized (object) {
                String remoteAddress = null;
                if (this.httpRequest != null) {
                    remoteAddress = this.httpRequest.get().getRemoteAddr();
                }
                for (NetworkAddress address : this.allowedAddresses) {
                    if (remoteAddress == null || !address.isValid(remoteAddress)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private boolean isLocalhost() {
        if (this.httpRequest != null) {
            String remoteAddr = this.httpRequest.get().getRemoteAddr();
            return remoteAddr != null && LOCALHOST_ADDRESSES.contains(remoteAddr);
        }
        return false;
    }

    private boolean isRoleAuthorized(UserId userId, ContainerRequest request) {
        return this.roleAuthorization.isRoleAuthorized(userId.getRole(), request);
    }

    private WebApplicationException respondUnauthorized(ContainerRequest request) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"SES-imagotag Core Service\"").build());
    }

    private WebApplicationException respondForbidden(ContainerRequest request) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Requests from source address not allowed").build());
    }

    @Override
    public void configurationChanged(String key, String value, Transaction<?> transaction) throws Exception {
        if (key.equals("apiSecurityAllowedAddresses")) {
            this.parseAllowedAddresses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAllowedAddresses() {
        String allowedAddressString = Config.getApiSecurityAllowedAddresses();
        if (allowedAddressString != null && !allowedAddressString.isEmpty()) {
            try {
                Collection newAddresses = NetworkAddressUtils.parseNetworkAddresses((String)allowedAddressString);
                Object object = this.allowedAddressLock;
                synchronized (object) {
                    this.allowedAddresses = Collections.unmodifiableCollection(newAddresses);
                }
            }
            catch (Exception exc) {
                logger.warn("Could not parse allowed addresses: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }
}

