/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey;

import at.mrdevelopment.toolkit.log.ESLLogger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class UncaughtExceptionMapper
implements ExceptionMapper<Throwable> {
    static ESLLogger logger = ESLLogger.getLogger(UncaughtExceptionMapper.class);

    public Response toResponse(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        logger.warn("Error during web service request (%s): %s", new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()});
        logger.logExceptionIfDebugEnabled(throwable);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }
}

