/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey;

import at.mrdevelopment.esl.jersey.DisabledNetworkInterfaceFilter;
import at.mrdevelopment.esl.jersey.FilterPriority;
import at.mrdevelopment.esl.jersey.UncaughtExceptionMapper;
import at.mrdevelopment.toolkit.InitializationException;
import com.google.common.collect.Sets;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;

public class JerseyResourceConfig
extends Application {
    private final Set<Class<?>> classes = new HashSet();
    private final Set<Object> singletons = new HashSet<Object>();
    private final Set<ContainerRequestFilter> requestFilters = new HashSet<ContainerRequestFilter>();
    private final Set<ContainerResponseFilter> responseFilters = new HashSet<ContainerResponseFilter>();
    private final DisabledNetworkInterfaceFilter disabledNetworkInterfaceFilter;

    public JerseyResourceConfig(DisabledNetworkInterfaceFilter disabledNetworkInterfaceFilter) throws InitializationException {
        this.disabledNetworkInterfaceFilter = disabledNetworkInterfaceFilter;
        this.classes.add(UncaughtExceptionMapper.class);
    }

    public Set<Class<?>> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    public Set<Object> getSingletons() {
        return Collections.unmodifiableSet(this.singletons);
    }

    public void addClass(Class<?> resourceClass) {
        this.classes.add(resourceClass);
    }

    public void addSingleton(Object singleton) {
        this.singletons.add(singleton);
    }

    public void addRequestFilter(ContainerRequestFilter requestFilter) {
        this.requestFilters.add(requestFilter);
    }

    public Set<ContainerRequestFilter> getContainerRequestFilters() {
        ArrayList<ContainerRequestFilter> list = new ArrayList<ContainerRequestFilter>(this.requestFilters);
        Collections.sort(list, new Comparator<ContainerRequestFilter>(){

            @Override
            public int compare(ContainerRequestFilter o1, ContainerRequestFilter o2) {
                FilterPriority a1 = o1.getClass().getAnnotation(FilterPriority.class);
                FilterPriority a2 = o2.getClass().getAnnotation(FilterPriority.class);
                if (a1 != null && a2 != null) {
                    return a1.value() - a2.value();
                }
                return 10;
            }
        });
        return Sets.newLinkedHashSet(list);
    }

    public void addResponseFilter(ContainerResponseFilter responseFilter) {
        this.responseFilters.add(responseFilter);
    }

    public Set<ContainerResponseFilter> getContainerResponseFilters() {
        ArrayList<ContainerResponseFilter> list = new ArrayList<ContainerResponseFilter>(this.responseFilters);
        Collections.sort(list, new Comparator<ContainerResponseFilter>(){

            @Override
            public int compare(ContainerResponseFilter o1, ContainerResponseFilter o2) {
                FilterPriority a1 = o1.getClass().getAnnotation(FilterPriority.class);
                FilterPriority a2 = o2.getClass().getAnnotation(FilterPriority.class);
                if (a1 != null && a2 != null) {
                    return a1.value() - a2.value();
                }
                return 10;
            }
        });
        return Sets.newLinkedHashSet(list);
    }

    public DisabledNetworkInterfaceFilter getDisabledNetworkInterfaceFilter() {
        return this.disabledNetworkInterfaceFilter;
    }
}

