/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey;

import at.mrdevelopment.esl.certificate.ESLKeyManagerFactory;
import at.mrdevelopment.esl.certificate.ESLTrustManager;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.jersey.AllowAllOriginsResponseFilter;
import at.mrdevelopment.esl.jersey.JerseyResourceConfig;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Joiner;
import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.container.grizzly2.GrizzlyServerFactory;
import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.net.URI;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JerseyHttpServer
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(JerseyHttpServer.class);
    private static final String REQUEST_LOGGER_NAME = "com.imagotag.api.request";
    private static final String RESPONSE_LOGGER_NAME = "com.imagotag.api.response";
    private HttpServer httpServer = null;

    public JerseyHttpServer(JerseyResourceConfig application, int port, boolean allowAllOrigins, boolean useSSL, boolean verifyClientCertificates, String bindAddress) throws InitializationException {
        try {
            if (!application.getClasses().isEmpty()) {
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
                logger.info("Starting Grizzly Webserver");
                ApplicationAdapter rc = new ApplicationAdapter((Application)application);
                rc.getContainerRequestFilters().add(new LoggingFilter(Logger.getLogger(REQUEST_LOGGER_NAME)));
                rc.getContainerResponseFilters().add(new LoggingFilter(Logger.getLogger(RESPONSE_LOGGER_NAME)));
                for (ContainerRequestFilter requestFilter : application.getContainerRequestFilters()) {
                    rc.getContainerRequestFilters().add(requestFilter);
                }
                for (ContainerResponseFilter responseFilter : application.getContainerResponseFilters()) {
                    rc.getContainerResponseFilters().add(responseFilter);
                }
                if (allowAllOrigins) {
                    rc.getContainerResponseFilters().add(new AllowAllOriginsResponseFilter());
                }
                URI uri = this.createUri(bindAddress, application, port, useSSL);
                if (useSSL) {
                    SSLContext context = SSLContext.getInstance("TLS");
                    TrustManager[] trustManagers = new X509TrustManager[]{new ESLTrustManager(Config.isSslStrictVerification(), verifyClientCertificates)};
                    context.init(new ESLKeyManagerFactory().getKeyManagers(), trustManagers, null);
                    SSLEngineConfigurator sslConfigurator = new SSLEngineConfigurator(context);
                    sslConfigurator.setClientMode(false);
                    sslConfigurator.setWantClientAuth(false);
                    sslConfigurator.setNeedClientAuth(verifyClientCertificates);
                    this.httpServer = GrizzlyServerFactory.createHttpServer((URI)uri, (HttpHandler)((HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (ResourceConfig)rc)), (boolean)true, (SSLEngineConfigurator)sslConfigurator);
                } else {
                    this.httpServer = GrizzlyServerFactory.createHttpServer((URI)uri, (ResourceConfig)rc);
                }
                this.httpServer.getServerConfiguration().setTraceEnabled(true);
                if (application.getDisabledNetworkInterfaceFilter() != null) {
                    logger.info("Disabling API traffic from interfaces: %s", new Object[]{Joiner.on((String)", ").join(application.getDisabledNetworkInterfaceFilter().getDisabledInterfaces())});
                    for (NetworkListener networkListener : this.httpServer.getListeners()) {
                        networkListener.getFilterChain().add((Object)application.getDisabledNetworkInterfaceFilter());
                    }
                }
            }
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private URI createUri(String bindAddress, JerseyResourceConfig application, int port, boolean useSSL) {
        String prefix = useSSL ? "https://" : "http://";
        String host = bindAddress != null ? bindAddress : "0.0.0.0";
        return UriBuilder.fromUri((String)String.format("%s%s/", prefix, host)).port(port).build(new Object[0]);
    }

    public void shutdown() {
        if (this.httpServer != null) {
            logger.info("Stopping Grizzly Webserver");
            this.httpServer.stop();
        }
    }
}

