/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.jersey;

import at.mrdevelopment.esl.jersey.FilterPriority;
import at.mrdevelopment.toolkit.http.BlockedRequestHandler;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@FilterPriority(value=2)
public class BlockingRequestFilter
implements ContainerRequestFilter {
    private final BlockedRequestHandler blockedRequestHandler;

    public BlockingRequestFilter(BlockedRequestHandler blockedRequestHandler) {
        this.blockedRequestHandler = blockedRequestHandler;
    }

    public ContainerRequest filter(ContainerRequest containerRequest) {
        HttpRequestMethod method = HttpRequestMethod.valueOf((String)containerRequest.getMethod().toUpperCase());
        if (this.blockedRequestHandler.isBlocked(method, containerRequest.getRequestUri())) {
            throw new WebApplicationException(Response.status((int)405).entity((Object)this.blockedRequestHandler.getResponseMessage()).build());
        }
        return containerRequest;
    }
}

