/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.http;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.csvimport.LicenceCsvImport;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.licencing.LicenceXMLSerializer;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.type.Licence;
import at.mrdevelopment.esl.xml.UploadLicenceHTMLFormXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.MultipartFileParser;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;

@Route(route="/service")
public class UploadLicenceRequestHandler
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(UploadLicenceRequestHandler.class);
    private final Level1Interface level1;
    private final LicenceXMLSerializer licenceSerializer;
    private final UploadLicenceHTMLFormXMLSerializer uploadLicenceHTMLFormXMLSerializer;

    public UploadLicenceRequestHandler(Level1Interface level1) throws InitializationException {
        this.level1 = level1;
        this.licenceSerializer = new LicenceXMLSerializer();
        this.uploadLicenceHTMLFormXMLSerializer = new UploadLicenceHTMLFormXMLSerializer();
    }

    @Restrict
    @Route(method=HttpRequestMethod.GET, route="uploadLicence.xml")
    public void uploadLicenceXML(WebserviceRequest request, WebserviceResponse response) throws Exception {
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        Document document = this.uploadLicenceHTMLFormXMLSerializer.toXML(serviceStatus);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restrict
    @Route(method=HttpRequestMethod.POST, route="licence/upload.html")
    public void uploadLicence(WebserviceRequest request, WebserviceResponse response) throws IOException, SerializeException {
        block13: {
            block12: {
                ByteArrayInputStream inputStream;
                ByteArrayOutputStream outputStream;
                block11: {
                    HttpEntity body = request.getBody();
                    if (!body.getContentType().getValue().contains("multipart/form-data")) break block12;
                    MultipartFileParser parser = new MultipartFileParser();
                    outputStream = null;
                    inputStream = null;
                    try {
                        outputStream = new ByteArrayOutputStream();
                        String fileName = parser.writeFileFromStream(body, (OutputStream)outputStream);
                        if (fileName != null) {
                            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                            if (FilenameUtils.isExtension((String)fileName, (String[])new String[]{"licence", "license"})) {
                                try {
                                    Licence licence = this.licenceSerializer.parseXML((InputStream)inputStream);
                                    if (this.addLicence(licence)) {
                                        response.respondMessage(String.format("Licence imported from %s", fileName));
                                        break block11;
                                    }
                                    response.respondMessage(String.format("No licence imported from %s", fileName), 400);
                                }
                                catch (Exception exc) {
                                    logger.warn("Failed to import licence from %s: %s", new Object[]{fileName, exc.getMessage()});
                                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                                    response.respondMessage(String.format("Failed to import licence from %s: %s", fileName, exc.getMessage()), 400);
                                }
                                break block11;
                            }
                            if (FilenameUtils.isExtension((String)fileName.toLowerCase(), (String)"csv")) {
                                try {
                                    LicenceCsvImport licenceImport = new LicenceCsvImport();
                                    List licences = licenceImport.importFromStream((InputStream)inputStream);
                                    int numberOfLicencesAdded = this.addLicences(licences);
                                    if (numberOfLicencesAdded == licences.size()) {
                                        response.respondMessage(String.format("%d licence%s imported from %s", numberOfLicencesAdded, numberOfLicencesAdded == 1 ? "" : "s", fileName));
                                        break block11;
                                    }
                                    response.respondMessage(String.format("%d of %d licence%s imported from %s", numberOfLicencesAdded, licences.size(), licences.size() == 1 ? "" : "s", fileName), 400);
                                }
                                catch (Exception exception) {
                                    response.respondMessage(String.format("Failed to import licence from %s", fileName), 400);
                                }
                                break block11;
                            }
                            response.respondMessage(String.format("Wrong license file extension %s", fileName), 400);
                            break block11;
                        }
                        response.respondMessage(String.format("Could not read licence", new Object[0]), 400);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close((OutputStream)outputStream);
                        StreamUtils.close(inputStream);
                        throw throwable;
                    }
                }
                StreamUtils.close((OutputStream)outputStream);
                StreamUtils.close((InputStream)inputStream);
                break block13;
            }
            response.respondBadRequest();
        }
    }

    public String getRouteFromPattern(String route) {
        return route;
    }

    private boolean addLicence(Licence licence) throws DatasetException {
        DatasetQuery query = this.level1.getQuery("licencerecord/index");
        int countBefore = this.level1.executeCountQuery(query, null);
        this.level1.addLicense(licence);
        int countAfter = this.level1.executeCountQuery(query, null);
        return countAfter > countBefore;
    }

    private int addLicences(List<Licence> licences) throws DatasetException {
        int numberOfLicencesAdded = 0;
        for (Licence licence : licences) {
            numberOfLicencesAdded += this.addLicence(licence) ? 1 : 0;
        }
        return numberOfLicencesAdded;
    }
}

