/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom;

import at.mrdevelopment.esl.core.ServiceStatusProvider;
import at.mrdevelopment.esl.custom.AbstractBlockedRequestHandler;
import at.mrdevelopment.esl.custom.ConnectorConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceOptions;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.DefaultDatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.server.AbstractServiceStatusDataProvider;
import at.mrdevelopment.esl.server.DiskStateWatcher;
import at.mrdevelopment.esl.server.DummyDiskStateWatcher;
import at.mrdevelopment.esl.server.FileSystemWatcher;
import at.mrdevelopment.esl.server.ServiceStatusDataProvider;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.DynamicXmlRedirectHttpResource;
import at.mrdevelopment.toolkit.http.HttpResource;
import at.mrdevelopment.toolkit.licensing.SystemSerial;
import java.io.File;
import java.util.Collection;
import java.util.UUID;

public class ServerStartupSettings {
    private final ConnectorConfiguration connectorConfiguration;
    private final AbstractServiceStatusDataProvider serviceStatusDataProvider;
    private final AbstractBlockedRequestHandler blockedRequestHandler;
    private final SystemSerial.SystemType type;
    private final int deviceId;
    private final int serviceLevel;
    private final int listenPort;
    private final HttpResource httpResource;
    private final DatabaseMaintenanceOptions databaseMaintenanceOptions;
    private final Collection<String> disabledNetworkInterfaces;
    private UUID databaseId;
    private final File importFile;
    private final boolean blockLocalhost;
    private final FileSystemWatcher fileSystemWatcher;
    private final DiskStateWatcher diskStateWatcher;
    private final DatabaseMaintenanceStrategy databaseMaintenanceStrategy;
    private final String bindAddress;

    public ServerStartupSettings(ConnectorConfiguration connectorConfiguration, int serviceLevel, int listenPort, DatabaseMaintenanceOptions databaseMaintenanceOptions, Collection<String> disabledNetworkInterfaces, File importFile, String bindAddress) throws InitializationException {
        this(connectorConfiguration, new ServiceStatusDataProvider(), null, 0, serviceLevel, listenPort, databaseMaintenanceOptions, null, true, disabledNetworkInterfaces, importFile, new FileSystemWatcher(), new DummyDiskStateWatcher(), new DefaultDatabaseMaintenanceStrategy(), bindAddress);
    }

    public ServerStartupSettings(ConnectorConfiguration connectorConfiguration, AbstractServiceStatusDataProvider serviceStatusDataProvider, SystemSerial.SystemType type, int deviceId, int serviceLevel, int listenPort, DatabaseMaintenanceOptions databaseMaintenanceOptions, Collection<String> disabledNetworkInterfaces, String bindAddress) throws InitializationException {
        this(connectorConfiguration, serviceStatusDataProvider, type, deviceId, serviceLevel, listenPort, (HttpResource)new DynamicXmlRedirectHttpResource(connectorConfiguration.getStylesheet(), "/service/dashboard.xml"), databaseMaintenanceOptions, null, true, disabledNetworkInterfaces, null, new FileSystemWatcher(), new DummyDiskStateWatcher(), new DefaultDatabaseMaintenanceStrategy(), bindAddress);
    }

    public ServerStartupSettings(ConnectorConfiguration connectorConfiguration, AbstractServiceStatusDataProvider serviceStatusDataProvider, SystemSerial.SystemType type, int deviceId, int serviceLevel, int listenPort, DatabaseMaintenanceOptions databaseMaintenanceOptions, AbstractBlockedRequestHandler blockedRequestHandler, boolean blockLocalhost, Collection<String> disabledNetworkInterfaces, File importFile, FileSystemWatcher fileSystemWatcher, DiskStateWatcher diskStateWatcher, DatabaseMaintenanceStrategy databaseMaintenanceStrategy, String bindAddress) throws InitializationException {
        this(connectorConfiguration, serviceStatusDataProvider, type, deviceId, serviceLevel, listenPort, (HttpResource)new DynamicXmlRedirectHttpResource(connectorConfiguration.getStylesheet(), "/service/dashboard.xml"), databaseMaintenanceOptions, blockedRequestHandler, blockLocalhost, disabledNetworkInterfaces, importFile, fileSystemWatcher, diskStateWatcher, databaseMaintenanceStrategy, bindAddress);
    }

    public ServerStartupSettings(ConnectorConfiguration connectorConfiguration, AbstractServiceStatusDataProvider serviceStatusDataProvider, SystemSerial.SystemType type, int deviceId, int serviceLevel, int listenPort, HttpResource httpResource, DatabaseMaintenanceOptions databaseMaintenanceOptions, AbstractBlockedRequestHandler blockedRequestHandler, boolean blockLocalhost, Collection<String> disabledNetworkInterfaces, File importFile, FileSystemWatcher fileSystemWatcher, DiskStateWatcher diskStateWatcher, DatabaseMaintenanceStrategy databaseMaintenanceStrategy, String bindAddress) {
        this.connectorConfiguration = connectorConfiguration;
        this.serviceStatusDataProvider = serviceStatusDataProvider;
        this.blockedRequestHandler = blockedRequestHandler;
        this.type = type;
        this.deviceId = deviceId;
        this.serviceLevel = serviceLevel;
        this.listenPort = listenPort;
        this.httpResource = httpResource;
        this.databaseMaintenanceOptions = databaseMaintenanceOptions;
        this.disabledNetworkInterfaces = disabledNetworkInterfaces;
        this.importFile = importFile;
        this.blockLocalhost = blockLocalhost;
        this.fileSystemWatcher = fileSystemWatcher;
        this.diskStateWatcher = diskStateWatcher;
        this.databaseMaintenanceStrategy = databaseMaintenanceStrategy;
        this.bindAddress = bindAddress;
    }

    public ConnectorConfiguration getConnectorConfiguration() {
        return this.connectorConfiguration;
    }

    public AbstractServiceStatusDataProvider getServiceStatusDataProvider() {
        return this.serviceStatusDataProvider;
    }

    public AbstractBlockedRequestHandler getBlockedRequestHandler(ServiceStatusProvider serviceStatusProvider) {
        if (this.blockedRequestHandler != null) {
            this.blockedRequestHandler.setServiceStatusProvider(serviceStatusProvider);
        }
        return this.blockedRequestHandler;
    }

    public SystemSerial.SystemType getType() {
        return this.type;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public HttpResource getHttpResource() {
        return this.httpResource;
    }

    public DatabaseMaintenanceOptions geDatabaseMaintenanceOptions() {
        return this.databaseMaintenanceOptions;
    }

    public Collection<String> getDisabledNetworkInterfaces() {
        return this.disabledNetworkInterfaces;
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setDatabaseId(UUID databaseId) {
        this.databaseId = databaseId;
    }

    public UUID getDatabaseId() {
        return this.databaseId;
    }

    public boolean isBlockLocalhost() {
        return this.blockLocalhost;
    }

    public FileSystemWatcher getFileSystemWatcher() {
        return this.fileSystemWatcher;
    }

    public DiskStateWatcher getDiskStateWatcher() {
        return this.diskStateWatcher;
    }

    public DatabaseMaintenanceStrategy getDatabaseMaintenanceStrategy() {
        return this.databaseMaintenanceStrategy;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }
}

