/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom;

import at.mrdevelopment.esl.custom.ESLConnector;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.file.FileUtils;
import com.imagotag.rendering.ImageRenderingEngine;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ConnectorConfiguration {
    private final String stylesheet;
    private final List<File> configurationFiles = new ArrayList<File>();
    private final List<File> recordFiles = new ArrayList<File>();
    private final List<File> datasetFiles = new ArrayList<File>();
    private File renderingEngineFile;

    public ConnectorConfiguration(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public void addConnectorConfiguration(File configFile) {
        if (configFile != null) {
            this.configurationFiles.add(configFile);
        }
    }

    public void addRecordConfiguration(File recordFile) {
        if (recordFile != null) {
            this.recordFiles.add(recordFile);
        }
    }

    public void addDatasetConfiguration(File datasetFile) {
        if (datasetFile != null) {
            this.datasetFiles.add(datasetFile);
        }
    }

    public Collection<Class<?>> loadRecordClasses(ClassLoader classLoader) throws InitializationException {
        Collection<String> recordClassNames = this.loadClassNames(classLoader, this.recordFiles);
        ArrayList recordClasses = new ArrayList();
        for (String recordClassName : recordClassNames) {
            try {
                recordClasses.add(classLoader.loadClass(recordClassName));
            }
            catch (ClassNotFoundException exc) {
                throw new InitializationException((Throwable)exc, "Record class not found", new Object[0]);
            }
        }
        return recordClasses;
    }

    public Collection<Class<?>> loadDatasetClasses(ClassLoader classLoader) throws InitializationException {
        Collection<String> datasetClassNames = this.loadClassNames(classLoader, this.datasetFiles);
        ArrayList datasetClasses = new ArrayList();
        for (String datasetClassName : datasetClassNames) {
            try {
                datasetClasses.add(classLoader.loadClass(datasetClassName));
            }
            catch (ClassNotFoundException exc) {
                throw new InitializationException((Throwable)exc, "Dataset class not found", new Object[0]);
            }
        }
        return datasetClasses;
    }

    public Collection<String> loadConnectorClassNames(ClassLoader classLoader, Class<? extends ESLConnector> connectorType) throws InitializationException {
        Collection<String> connectorClassNames = this.loadClassNames(classLoader, this.configurationFiles);
        ArrayList<String> filteredConnectorClassNames = new ArrayList<String>();
        for (String connectorClassName : connectorClassNames) {
            try {
                if (!this.isConnector(classLoader, connectorType, connectorClassName.trim())) continue;
                filteredConnectorClassNames.add(connectorClassName);
            }
            catch (ClassNotFoundException exc) {
                throw new InitializationException((Throwable)exc, "Connector class not found", new Object[0]);
            }
        }
        return filteredConnectorClassNames;
    }

    protected Collection<String> loadClassNames(ClassLoader classLoader, Collection<File> files) throws InitializationException {
        LinkedList<String> classNames = new LinkedList<String>();
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                for (String line : FileUtils.readLines((File)file)) {
                    if (line.startsWith("#")) continue;
                    classNames.add(line);
                }
            }
            catch (IOException exc) {
                throw new InitializationException((Throwable)exc, "Could not read configuration file '%s'", new Object[]{file.getAbsolutePath()});
            }
            catch (RuntimeException exc) {
                throw new InitializationException((Throwable)exc, "Unknown error during connector loading", new Object[0]);
            }
        }
        return classNames;
    }

    protected boolean isExpectedType(ClassLoader classLoader, Class<?> expectedType, String className) throws ClassNotFoundException {
        Class<?> type = classLoader.loadClass(className);
        for (Class<?> implementingInterface : type.getInterfaces()) {
            if (implementingInterface != expectedType) continue;
            return true;
        }
        return false;
    }

    private boolean isConnector(ClassLoader classLoader, Class<? extends ESLConnector> connectorType, String className) throws ClassNotFoundException {
        return this.isExpectedType(classLoader, connectorType, className);
    }

    public String loadRenderingEngineClassName(ClassLoader classLoader) throws InitializationException {
        if (this.renderingEngineFile != null) {
            Collection<String> engineClassNames = this.loadClassNames(classLoader, Collections.singleton(this.renderingEngineFile));
            for (String engineClassName : engineClassNames) {
                try {
                    if (!this.isRenderingEngine(classLoader, engineClassName.trim())) continue;
                    return engineClassName;
                }
                catch (ClassNotFoundException exc) {
                    throw new InitializationException((Throwable)exc, "Rendering engine class not found", new Object[0]);
                }
            }
        }
        return null;
    }

    private boolean isRenderingEngine(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return this.isExpectedType(classLoader, ImageRenderingEngine.class, className);
    }

    public void addRenderingConfiguration(File renderingEngineFile) {
        this.renderingEngineFile = renderingEngineFile;
    }
}

