/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.configuration;

import at.mrdevelopment.esl.configuration.ConfigurationStorage;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PluginConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(PluginConfiguration.class);
    private final Map<String, Configuration> entries = Collections.synchronizedMap(new HashMap());
    private final ConfigurationStorage configurationStorage;

    public PluginConfiguration(ConfigurationStorage configurationStorage) {
        this.configurationStorage = configurationStorage;
    }

    void loadConfiguration(Configuration configuration) {
        this.entries.put(configuration.getKey(), configuration);
    }

    private String getValue(String key, BasicType type, String systemDefault, Transaction<?> transaction) throws DatasetException {
        try {
            if (!this.entries.containsKey(key)) {
                Configuration configuration = this.configurationStorage.getDefaultConfiguration().getDefault(key, type, systemDefault);
                this.configurationStorage.store(configuration.getKey(), type, systemDefault, configuration.getValue(), transaction);
                this.entries.put(key, configuration);
                return configuration.getValue();
            }
            Configuration configuration = this.entries.get(key);
            if (!Objects.equal((Object)configuration.getDefaultValue(), (Object)systemDefault)) {
                if (configuration.isDefault()) {
                    configuration.setValue(systemDefault);
                }
                configuration.setDefaultValue(systemDefault);
                this.configurationStorage.updateFromRecord(configuration, transaction, false);
                this.configurationStorage.store(configuration.getKey(), type, systemDefault, configuration.getValue(), transaction);
            }
            return configuration.getValue();
        }
        catch (Exception exc) {
            throw new DatasetException((Throwable)exc);
        }
    }

    public String getString(String key, String defaultValue, Transaction<?> transaction) throws DatasetException {
        return this.getValue(key, BasicType.STRING, defaultValue, transaction);
    }

    public int getInteger(String key, int defaultValue, Transaction<?> transaction) throws DatasetException, NumberFormatException {
        return Integer.parseInt(this.getValue(key, BasicType.INTEGER, Integer.toString(defaultValue), transaction));
    }

    public float getFloat(String key, float defaultValue, Transaction<?> transaction) throws DatasetException, NumberFormatException {
        return Float.parseFloat(this.getValue(key, BasicType.FLOAT, Float.toString(defaultValue), transaction));
    }

    public boolean getBoolean(String key, boolean defaultValue, Transaction<?> transaction) throws DatasetException {
        return Boolean.parseBoolean(this.getValue(key, BasicType.BOOLEAN, Boolean.toString(defaultValue), transaction));
    }
}

