/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.configuration;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.configuration.ConfigurationChangedListener;
import at.mrdevelopment.esl.configuration.CustomConfigurationChangedListener;
import at.mrdevelopment.esl.configuration.DefaultConfiguration;
import at.mrdevelopment.esl.configuration.PluginConfiguration;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.type.BasicType;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ConfigurationStorage {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationStorage.class);
    public static final String CUSTOM_KEY_PREFIX = "plugin";
    protected final ConfigurationDataset dataset;
    protected final DefaultConfiguration defaultConfiguration;
    protected final PluginConfiguration pluginConfiguration;
    private final List<ConfigurationChangedListener> listeners = new CopyOnWriteArrayList<ConfigurationChangedListener>();
    private final List<CustomConfigurationChangedListener> customListeners = new CopyOnWriteArrayList<CustomConfigurationChangedListener>();

    public ConfigurationStorage(ConfigurationDataset dataset) throws InitializationException {
        this.dataset = dataset;
        this.defaultConfiguration = new DefaultConfiguration();
        this.pluginConfiguration = new PluginConfiguration(this);
    }

    public PluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public DefaultConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public abstract void store(String var1, BasicType var2, String var3, String var4, Transaction<?> var5) throws DatasetException;

    protected void updateFromRecord(Configuration configuration, Transaction<?> transaction) throws DatasetException {
        this.updateFromRecord(configuration, transaction, true);
    }

    protected void updateFromRecord(Configuration configuration, Transaction<?> transaction, boolean notify) throws DatasetException {
        if (configuration.getName().startsWith(CUSTOM_KEY_PREFIX)) {
            logger.debug("Loading plugin configuration key %s", new Object[]{configuration.getName()});
            this.pluginConfiguration.loadConfiguration(configuration);
            if (notify) {
                try {
                    this.notifyCustomConfigurationChanged(configuration, transaction);
                }
                catch (Exception exc) {
                    throw new DatasetException((Throwable)exc);
                }
            }
        } else {
            try {
                logger.debug("Loading configuration key %s", new Object[]{configuration.getName()});
                Field field = Config.class.getDeclaredField(configuration.getKey());
                field.setAccessible(true);
                field.set(null, configuration.getParsedValue());
                if (notify) {
                    this.notifyConfigurationChanged(configuration, transaction);
                }
            }
            catch (NoSuchFieldException exc) {
                logger.warn("Ignoring unknown configuration key '%s'", new Object[]{configuration.getKey()});
            }
            catch (SerializeException exc) {
                throw new DatasetException((Throwable)exc);
            }
            catch (Exception exc) {
                throw new DatasetException((Throwable)exc);
            }
        }
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void addCustomConfigurationChangedListener(CustomConfigurationChangedListener listener) {
        this.customListeners.add(listener);
    }

    public void removeCustomConfigurationChangedListener(CustomConfigurationChangedListener listener) {
        this.customListeners.remove(listener);
    }

    private void notifyConfigurationChanged(Configuration configuration, Transaction<?> transaction) throws Exception {
        for (ConfigurationChangedListener listener : this.listeners) {
            listener.configurationChanged(configuration.getKey(), configuration.getValue(), transaction);
        }
    }

    private void notifyCustomConfigurationChanged(Configuration configuration, Transaction<?> transaction) throws Exception {
        for (CustomConfigurationChangedListener listener : this.customListeners) {
            listener.customConfigurationChanged(configuration.getKey(), configuration.getValue(), transaction);
        }
    }
}

