/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.battery.BatteryCalculationData;
import at.mrdevelopment.esl.battery.BatteryClassificationStrategy;
import at.mrdevelopment.esl.battery.CalculatedPowerStatus;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import org.joda.time.DateTime;

public class BatteryStatusFactory {
    static ESLLogger logger = ESLLogger.getLogger(BatteryStatusFactory.class);
    private static final Version SIGRID_VERSION = Version.fromString((String)"3.1.0");

    public List<Task> createTasksForLabel(LabelInfo labelInfo) {
        BatteryClassificationStrategy strategy = this.getStrategyForLabel(labelInfo);
        return strategy.createTasks(labelInfo.getLabelId());
    }

    public CalculatedPowerStatus calculateBatteryStatusForLabel(BatteryCalculationData calculationData) {
        BatteryClassificationStrategy strategy = this.getStrategyForLabel(calculationData.getLabelInfo());
        PowerStatus powerStatus = PowerStatus.UNKNOWN;
        DateTime timestamp = calculationData.getTimestamp();
        try {
            powerStatus = strategy.calculateBatteryStatus(calculationData);
        }
        catch (IllegalArgumentException exc) {
            logger.info("Not all necessary information successfully queried for battery classification for label %s", new Object[]{calculationData.getLabelInfo().getLabelIdString()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            timestamp = null;
        }
        logger.debug("Setting calculated power status for label %s to %s", new Object[]{calculationData.getLabelInfo().getLabelIdString(), powerStatus.name()});
        return new CalculatedPowerStatus(powerStatus, timestamp);
    }

    protected BatteryClassificationStrategy getStrategyForLabel(LabelInfo labelInfo) {
        LabelType labelType = labelInfo.getLabelId().getLabelType();
        Version version = labelInfo.getFirmwareVersion();
        if (version.isOlder(SIGRID_VERSION)) {
            if (labelType == LabelType.STAG_256) {
                return BatteryClassificationStrategy.LEGACY_SINGLE_CELL;
            }
            return BatteryClassificationStrategy.LEGACY_MULTI_CELL;
        }
        return BatteryClassificationStrategy.DEFAULT;
    }
}

