/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.battery;

import at.mrdevelopment.esl.battery.BatteryCalculationData;
import at.mrdevelopment.esl.battery.BatterySample;
import at.mrdevelopment.esl.battery.ProductConfig;
import at.mrdevelopment.esl.core.BatteryResistanceSensor;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.McuSupplyVoltageSensor;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.TemperatureSensor;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.tasks.GetConfigTask;
import at.mrdevelopment.esl.tasks.QuerySensorTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public enum BatteryClassificationStrategy {
    DEFAULT{

        @Override
        public List<Task> createTasks(LabelId labelId) {
            ArrayList<GetConfigTask> tasks = new ArrayList<GetConfigTask>();
            tasks.add(new GetConfigTask(labelId, TaskPriority.LOW, 0L, false, (Collection)Lists.newArrayList((Object[])new LabelConfig[]{LabelConfig.BATTERY_MEASUREMENT_INFO})));
            tasks.add(new GetConfigTask(labelId, TaskPriority.LOW, 0L, false, (Collection)Lists.newArrayList((Object[])new LabelConfig[]{LabelConfig.BATTERY_MEASUREMENT_SAMPLE})));
            return Collections.unmodifiableList(tasks);
        }

        @Override
        public PowerStatus calculateBatteryStatus(BatteryCalculationData data) {
            Integer batterySampleValue = data.getValue(LabelConfig.BATTERY_MEASUREMENT_SAMPLE);
            Integer batteryInfo = data.getValue(LabelConfig.BATTERY_MEASUREMENT_INFO);
            Preconditions.checkArgument((batterySampleValue != null && batteryInfo != null ? 1 : 0) != 0);
            BatterySample batterySample = BatterySample.fromBatterySample((int)batterySampleValue);
            boolean lowTemperature = batterySample.getAdcTemperature() <= -5.0;
            ProductConfig config = ProductConfig.UNKNOWN;
            if (batteryInfo == 4095) {
                Long label = data.getLabelInfo().getLabel();
                int code = (int)(label >> 24);
                LabelType labelType = data.getLabelInfo().getLabelId().getLabelType();
                config = lowTemperature ? (code == 250 || code == 249 ? ProductConfig.FREEZER_DOUBLE_LOW : ProductConfig.fromLegacyLabel((LabelType)labelType, (boolean)lowTemperature)) : (code == 250 || code == 249 ? ProductConfig.FREEZER_DOUBLE : ProductConfig.fromLegacyLabel((LabelType)labelType, (boolean)lowTemperature));
            } else {
                config = ProductConfig.valueOf((int)batteryInfo, (boolean)lowTemperature);
            }
            return config.calculatePowerStatus(batterySample);
        }
    }
    ,
    LEGACY_SINGLE_CELL{

        @Override
        public List<Task> createTasks(LabelId labelId) {
            ArrayList<QuerySensorTask> tasks = new ArrayList<QuerySensorTask>();
            tasks.add(new QuerySensorTask(labelId, TaskPriority.LOW, 0L, false, (Collection)Lists.newArrayList((Object[])new LabelSensor[]{LabelSensor.TEMPERATURE_SENSOR, LabelSensor.MCU_SUPPLY_VOLTAGE_SENSOR})));
            return Collections.unmodifiableList(tasks);
        }

        @Override
        public PowerStatus calculateBatteryStatus(BatteryCalculationData data) {
            Integer rawTemperature = data.getRawValue(LabelSensor.TEMPERATURE_SENSOR);
            Integer rawMcuVoltage = data.getRawValue(LabelSensor.MCU_SUPPLY_VOLTAGE_SENSOR);
            Preconditions.checkArgument((rawTemperature != null && rawMcuVoltage != null ? 1 : 0) != 0);
            Double temperature = new TemperatureSensor().getValue(rawTemperature.intValue());
            Double mcuVoltage = new McuSupplyVoltageSensor().getValue(rawMcuVoltage.intValue());
            if (temperature > -5.0) {
                if (mcuVoltage < 2.75) {
                    return PowerStatus.BAD;
                }
                if (mcuVoltage > 2.9) {
                    return PowerStatus.GOOD;
                }
                return PowerStatus.LOW;
            }
            return PowerStatus.UNKNOWN;
        }
    }
    ,
    LEGACY_MULTI_CELL{

        @Override
        public List<Task> createTasks(LabelId labelId) {
            ArrayList<QuerySensorTask> tasks = new ArrayList<QuerySensorTask>();
            tasks.add(new QuerySensorTask(labelId, TaskPriority.LOW, 0L, false, (Collection)Lists.newArrayList((Object[])new LabelSensor[]{LabelSensor.TEMPERATURE_SENSOR, LabelSensor.MCU_SUPPLY_VOLTAGE_SENSOR})));
            tasks.add(new QuerySensorTask(labelId, TaskPriority.LOW, 0L, false, (Collection)Lists.newArrayList((Object[])new LabelSensor[]{LabelSensor.BATTERY_RESISTANCE_SENSOR})));
            return Collections.unmodifiableList(tasks);
        }

        @Override
        public PowerStatus calculateBatteryStatus(BatteryCalculationData data) {
            Integer rawTemperature = data.getRawValue(LabelSensor.TEMPERATURE_SENSOR);
            Integer rawMcuVoltage = data.getRawValue(LabelSensor.MCU_SUPPLY_VOLTAGE_SENSOR);
            Integer rawBatteryResistance = data.getRawValue(LabelSensor.BATTERY_RESISTANCE_SENSOR);
            Preconditions.checkArgument((rawTemperature != null && rawMcuVoltage != null && rawBatteryResistance != null ? 1 : 0) != 0);
            Double temperature = new TemperatureSensor().getValue(rawTemperature.intValue());
            Double mcuVoltage = new McuSupplyVoltageSensor().getValue(rawMcuVoltage.intValue());
            Double batteryResistance = new BatteryResistanceSensor().getValue(rawBatteryResistance.intValue());
            double uLowLoad = mcuVoltage - batteryResistance * 2.3 * Math.pow(10.0, -3.0);
            double uHighLoad = uLowLoad - batteryResistance * 23.0 * Math.pow(10.0, -3.0);
            BatterySample batterySample = new BatterySample(uLowLoad, uHighLoad, temperature.doubleValue());
            boolean lowTemperature = batterySample.getAdcTemperature() <= -5.0;
            LabelType labelType = data.getLabelInfo().getLabelId().getLabelType();
            ProductConfig config = ProductConfig.fromLegacyLabel((LabelType)labelType, (boolean)lowTemperature);
            return config.calculatePowerStatus(batterySample);
        }
    };

    private static final double LOW_TEMPERATURE_LIMIT = -5.0;

    public abstract List<Task> createTasks(LabelId var1);

    public abstract PowerStatus calculateBatteryStatus(BatteryCalculationData var1);
}

