/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.authentication;

import at.mrdevelopment.esl.authentication.TokenAuthenticator;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.apache.commons.lang.StringUtils;

public class TokenAuthUtils {
    static ESLLogger logger = ESLLogger.getLogger(TokenAuthUtils.class);

    public static String parseToken(String authorizationHeader) {
        String userToken;
        if (authorizationHeader == null) {
            logger.info("Missing authorization header");
            return null;
        }
        String value = authorizationHeader;
        String[] parts = StringUtils.split((String)value);
        if (parts.length != 2) {
            logger.info("Not a valid authentication request (%s)", new Object[]{value});
            return null;
        }
        if (!parts[0].equals("Token")) {
            logger.info("Not a token authentication request (%s)", new Object[]{value});
            return null;
        }
        if (parts[0] == null || parts[1] == null) {
            logger.info("Malformed token authentication request (%s)", new Object[]{value});
            return null;
        }
        String[] tokenParts = StringUtils.split((String)parts[1], (String)"=");
        if (tokenParts == null || tokenParts.length == 0) {
            logger.info("Malformed token authentication request (%s)", new Object[]{value});
            return null;
        }
        if (!(tokenParts.length != 2 || tokenParts[0] != null && tokenParts[0].equals("token"))) {
            logger.info("Malformed token authentication request (%s)", new Object[]{value});
            return null;
        }
        String string = userToken = tokenParts.length == 2 ? tokenParts[1] : tokenParts[0];
        if (userToken == null) {
            logger.info("Malformed token authentication request (%s)", new Object[]{value});
            return null;
        }
        userToken = StringUtils.replace((String)userToken, (String)"\"", (String)"");
        return userToken;
    }

    public static UserId authorizeWithToken(String userToken, TokenAuthenticator authenticator) {
        if (userToken == null) {
            return new RequestUser(Role.NONE);
        }
        UserId user = authenticator.authorize(userToken);
        logger.info("Token authentication request with token %s %s", new Object[]{userToken, user.isAuthorized() ? "successful" : "failed"});
        return user;
    }

    public static UserId authorize(String authorizationHeader, TokenAuthenticator authenticator) {
        String userToken = TokenAuthUtils.parseToken(authorizationHeader);
        return TokenAuthUtils.authorizeWithToken(userToken, authenticator);
    }
}

